//
//  MCGlobalFindPicker.h
//  MCApplication
//
//  Created by Ali Lalani on 28/02/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "MCWindowController.h"
#import "MCMenuManagerSupportProtocol.h"
#import "MCDisplayStateProtocol.h"

@class MCSimpleBox,MCWebKitTemplateView,MCTableView,MCArrayController,MCSplitView;

@interface MCGlobalFindPicker : MCWindowController <MCMenuManagerSupport,MCDisplayState> {
	IBOutlet NSTextField *resultsDescriptionField;
	IBOutlet MCSimpleBox *box;
	IBOutlet MCWebKitTemplateView *templateView;
	IBOutlet MCTableView *tableView;
	IBOutlet NSMatrix *matrix;
	IBOutlet NSSearchField *searchField;
	IBOutlet MCSplitView *splitView;
	
	IBOutlet MCArrayController *arrayController;

	BOOL __ignoreShowWindow;
	BOOL suspendSplitProportionWrite;
	
	//	// DISPLAY STATE
	NSMutableDictionary *displayState;
	id                   displayStateDelegate;	
}
- (NSArray *)resultsForQueryWithIndividualStatements;
- (NSArray *)resultsForQueryWithOrStatements;

- (IBAction)matrixDidAct:(id)sender;
- (IBAction)search:(id)sender;
- (IBAction)openObjects:(id)sender;

#pragma mark DisplayStateReadWrite
- (void)readWindowVisibilityFromDisplayState;
- (void)writeWindowVisibilityToDisplayState;

- (void)writeSelectedCellsToDisplayState;
- (void)readSelectedCellsFromDisplayState;

- (void)writeSplitProportionsToDisplayState;
- (void)readSplitProportionsFromDisplayState;
@end
